// "Time to Slow Down"
// Alexandre Dorion (alexandre.dorion@rogers.com)
// December 2005

//GLOBAL
global_settings
{
 assumed_gamma 1.7
}

//INCLUDES
#include "colors.inc"
#include "textures.inc"
#include "boat1.in1"
#include "ducky.in1"

//CAMERA
camera
{
 location <0,1,-5>
 right x*image_width/image_height
 look_at <0,.8,0>
}

//MATERIALS
#declare m_1 = material
{
 texture
 {
  pigment
  {
   rgb 1
  }
  finish
  {
   ambient 0.05
   diffuse 1
   phong 0.5
  }
 }
}
#declare m_2 = material
{
 texture
 {
  pigment
  {
   rgb .5
  }
  finish
  {
   ambient 0.3
   diffuse .7
  }
 }
}

//MOON
#declare moon = sphere
{
 <0,0,0>, 1 
 texture
 {
  pigment
  {
   image_map
   {
    jpeg "moon_map.jpg"
    map_type 1
   }
  }                                  
  finish
  {
   ambient 0.2
   diffuse 1
   phong 0
   brilliance .25
  }
 }
} 
object { moon no_shadow scale 3000 rotate <-25,-80,30> translate <0,6000,30000> }

//MOONLIGHT
light_source
{
 <0,6000,30000>
 color .2*Yellow+White*.8
 looks_like
 {
  moon
  scale 3000
  rotate <-25,-80,30>
 }
}

//SUNLIGHT
light_source
{
 <0,2000,10000>
 color .3*Yellow+White*2
 spotlight
 point_at <0,6000,30000>
 radius 90
 falloff 90
}

//STARS
sphere
{
 <0,0,0>, 1
 hollow on
 no_reflection
 texture
 {
  pigment
  {
   granite
   color_map
   {
    [ 0.000  0.270 color rgb 0 color rgb 0 ]
    [ 0.270  0.280 color rgb <.784,.784,1> color rgb <.784,.784,1> ]
    [ 0.280  0.470 color rgb 0 color rgb 0 ]
    [ 0.470  0.480 color rgb <.39.39.49> color rgb <.784,.784,1> ]
    [ 0.480  0.680 color rgb 0 color rgb 0 ]
    [ 0.680  0.690 color rgb <.39.39.49> color rgb <.784,.784,1> ]
    [ 0.690  0.880 color rgb 0 color rgb 0 ]
    [ 0.880  0.890 color rgb <.39.39.49> color rgb <.784,.784,1> ]
    [ 0.890  1.000 color rgb 0 color rgb 0 ]
   }
   turbulence 4 sine_wave scale .03
  }
  finish
  {
   diffuse 0
   ambient 1
  }
  scale .00001
 }
 scale 100000
}

//WATER
plane
{
 y, -4
 texture
 {
  Polished_Chrome
  normal
  {
   bumps 0.03
   scale .2*<1,0.25,0.25>
   turbulence 0.6
  }
  finish
  {
   ambient 0.1
   diffuse 0.7
   reflection 0.60
  }
 }
}

//FOG
fog
{
 fog_type 2
 distance 100
 color White*.3+Blue*.06
 fog_offset 0.1
 fog_alt 4
 turbulence 10
}

//CLOUDS
plane
{
 y,1 hollow  
 texture
 {
  pigment
  {
   bozo
   turbulence 0.76
   color_map
   {
    [0.4 rgbf <.8,.8,1.0,1> ]
    [1.0 rgbf <0.5,0.5,0.5,1>*.4 ]
   }
  }
  finish
  {
   ambient 0.1
   diffuse 0
  }
 }
 scale 500
}

//ISLAND
height_field
{
 jpeg "island.jpg"
 smooth
 translate <-0.5,-0.001,0>
 rotate y*-45
 scale <150,40,50>
 texture
 {
  pigment
  {
   Grey*.8+Blue*.05
  }
  normal
  {
   bumps 0.75
   scale 0.015
  }
  finish
  {
   ambient 0.1
   diffuse 0.7
  }
 }
 translate <15,-20,80>
}  

//BOAT
#declare sailboat = union
{
 object
 {
  TransSweep001_Raw
  scale .5
  rotate x*90
  translate y*.3
  matrix<1,0,0,-.5,1,0,0,0,1,0,0,0>
 }
 object
 {
  TransSweep001_Raw
  scale .25
  rotate x*90
  translate <-.5,.4,.5>
 }
 cylinder
 {
  <0,0,0>, <0,4,0>, 0.04
  translate<0,0,1>
 }
 cylinder
 {
  <0,0,0>, <0,4.18,0>, 0.01
  rotate z*21
  translate <1.5,0,1>
 }
 cylinder
 {
  <0,0,0>, <0,4.18,0>, 0.01
  rotate z*-21
  translate<-1.5,0,1>
 }
 cylinder
 {
  <0,0,0>, <0,2,0>, 0.08
  rotate z*90
  translate <1,.66,1>
 } 
 light_source
 {
  <1.5,.5,1>
  color .1*(.3*Yellow+White*.7)
 }
 sphere
 {
  <1.5,.4,1>, .04
  texture
  {
   pigment
   {
    color .4*Yellow+White*.6
   }
   finish
   {
    ambient 2
    diffuse 1
   }
  }
 }
}
object
{
 sailboat
 material
 {
  m_1
 }
 rotate y*-50
 translate <27,-4,55>
} 

//DUCKS
#declare loon = object
{
 ducky
 material
 {
  m_2
 }
 scale .03
 rotate -90*x-45*y
 translate <.25,-4.02,15>
}
object
{
 loon
}
object
{
 loon
 translate <.5,0,-1> 
}
